/*
 * Decompiled with CFR 0.152.
 */
package com.bdlington.Catalyst.modules;

import com.bdlington.Catalyst.CatalystAddon;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.renderer.Renderer3D;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.network.MeteorExecutor;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2826;

public class HoleTunnelStairs
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgHParams;
    private final SettingGroup sgTParams;
    private final SettingGroup sgSParams;
    private final SettingGroup sgRender;
    private final Setting<DetectionMode> detectionMode;
    private final Setting<Integer> maxChunks;
    private final Setting<Boolean> airBlocks;
    private final Setting<Integer> minY;
    private final Setting<Integer> maxY;
    private final Setting<Integer> minHoleDepth;
    private final Setting<Integer> minTunnelLength;
    private final Setting<Integer> minTunnelHeight;
    private final Setting<Integer> maxTunnelHeight;
    private final Setting<Boolean> diagonals;
    private final Setting<Integer> minDiagonalLength;
    private final Setting<Integer> minDiagonalWidth;
    private final Setting<Integer> maxDiagonalWidth;
    private final Setting<Integer> minStaircaseLength;
    private final Setting<Integer> minStaircaseHeight;
    private final Setting<Integer> maxStaircaseHeight;
    private final Setting<ShapeMode> shapeMode;
    private final Setting<SettingColor> holeLineColor;
    private final Setting<SettingColor> holeSideColor;
    private final Setting<SettingColor> tunnelLineColor;
    private final Setting<SettingColor> tunnelSideColor;
    private final Setting<SettingColor> staircaseLineColor;
    private final Setting<SettingColor> staircaseSideColor;
    private static final class_2350[] DIRECTIONS = new class_2350[]{class_2350.field_11034, class_2350.field_11039, class_2350.field_11043, class_2350.field_11035};
    private final Long2ObjectMap<TChunk> chunks;
    private final Queue<class_2791> chunkQueue;
    private final Set<class_238> holes;
    private final Set<class_238> tunnels;
    private final Set<class_238> staircases;

    public HoleTunnelStairs() {
        super(CatalystAddon.esp, "HoleTunnelStairs", "Finds and highlights holes and tunnels and stairs.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgHParams = this.settings.createGroup("Hole Parameters");
        this.sgTParams = this.settings.createGroup("Tunnel Parameters");
        this.sgSParams = this.settings.createGroup("Stairs Parameters");
        this.sgRender = this.settings.createGroup("Rendering");
        this.detectionMode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("Detection Mode")).description("Choose what to detect: holes, tunnels, stairs, or all.")).defaultValue((Object)DetectionMode.ALL)).build());
        this.maxChunks = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Chunks to process/tick")).description("Amount of Chunks to process per tick")).defaultValue((Object)10)).min(1).sliderRange(1, 100).build());
        this.airBlocks = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Detect only Air blocks as passable.")).description("Only marks tunnels or holes if their blocks are air as oppose to if the blocks are passable.")).defaultValue((Object)false)).build());
        this.minY = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Detection Y Minimum OffSet")).description("Scans blocks above or at this this many blocks from minimum build limit.")).min(0).sliderRange(0, 319).defaultValue((Object)0)).build());
        this.maxY = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Detection Y Maximum OffSet")).description("Scans blocks below or at this this many blocks from maximum build limit.")).min(0).sliderRange(0, 319).defaultValue((Object)0)).build());
        this.minHoleDepth = this.sgHParams.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Min Hole Depth")).description("Minimum depth for a hole to be detected")).defaultValue((Object)4)).min(1).sliderMax(20).build());
        this.minTunnelLength = this.sgTParams.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Min Tunnel Length")).description("Minimum length for a tunnel to be detected")).defaultValue((Object)3)).min(1).sliderMax(20).build());
        this.minTunnelHeight = this.sgTParams.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Min Tunnel Height")).description("Minimum height of the tunnels to be detected")).defaultValue((Object)2)).min(1).sliderMax(10).build());
        this.maxTunnelHeight = this.sgTParams.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Max Tunnel Height")).description("Maximum height of the tunnels to be detected")).defaultValue((Object)3)).min(2).sliderMax(10).build());
        this.diagonals = this.sgTParams.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Detect Diagonal Tunnels.")).description("Detects diagonal tunnels when tunnels are selected to be detected.")).defaultValue((Object)true)).build());
        this.minDiagonalLength = this.sgTParams.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Min Diagonal Tunnel Length")).description("Minimum length for diagonal tunnels to be detected")).defaultValue((Object)3)).min(1).sliderMax(20).visible(() -> this.diagonals.get())).build());
        this.minDiagonalWidth = this.sgTParams.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Min Diagonal Tunnel Width")).description("Minimum width for diagonal tunnels to be detected")).defaultValue((Object)2)).min(2).sliderMax(10).visible(() -> this.diagonals.get())).build());
        this.maxDiagonalWidth = this.sgTParams.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Max Diagonal Tunnel Width")).description("Maximum width for diagonal tunnels to be detected")).defaultValue((Object)4)).min(2).sliderMax(10).visible(() -> this.diagonals.get())).build());
        this.minStaircaseLength = this.sgSParams.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Min Staircase Length")).description("Minimum length for a staircase to be detected")).defaultValue((Object)3)).min(1).sliderMax(20).build());
        this.minStaircaseHeight = this.sgSParams.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Min Staircase Height")).description("Minimum height of the staircase to be detected")).defaultValue((Object)3)).min(2).sliderMax(10).build());
        this.maxStaircaseHeight = this.sgSParams.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Max Staircase Height")).description("Maximum height of the staircase to be detected")).defaultValue((Object)5)).min(2).sliderMax(10).build());
        this.shapeMode = this.sgRender.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("shape-mode")).description("How the shapes are rendered.")).defaultValue((Object)ShapeMode.Both)).build());
        this.holeLineColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("hole-line-color")).description("The color of the lines for the holes being rendered.")).defaultValue(new SettingColor(255, 0, 0, 95)).build());
        this.holeSideColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("hole-side-color")).description("The color of the sides for the holes being rendered.")).defaultValue(new SettingColor(255, 0, 0, 30)).build());
        this.tunnelLineColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("tunnel-line-color")).description("The color of the lines for the tunnels being rendered.")).defaultValue(new SettingColor(0, 0, 255, 95)).build());
        this.tunnelSideColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("tunnel-side-color")).description("The color of the sides for the tunnels being rendered.")).defaultValue(new SettingColor(0, 0, 255, 30)).build());
        this.staircaseLineColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("staircase-line-color")).description("The color of the lines for the staircases being rendered.")).defaultValue(new SettingColor(255, 0, 255, 95)).build());
        this.staircaseSideColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("staircase-side-color")).description("The color of the sides for the staircases being rendered.")).defaultValue(new SettingColor(255, 0, 255, 30)).build());
        this.chunks = new Long2ObjectOpenHashMap();
        this.chunkQueue = new LinkedList<class_2791>();
        this.holes = Collections.newSetFromMap(new ConcurrentHashMap());
        this.tunnels = Collections.newSetFromMap(new ConcurrentHashMap());
        this.staircases = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public Set<class_238> getHoles() {
        return new HashSet<class_238>(this.holes);
    }

    public void onDeactivate() {
        this.chunks.clear();
        this.chunkQueue.clear();
        this.holes.clear();
        this.tunnels.clear();
        this.staircases.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    private void onTick(TickEvent.Post event) {
        Long2ObjectMap<TChunk> long2ObjectMap = this.chunks;
        synchronized (long2ObjectMap) {
            for (TChunk tChunk2 : this.chunks.values()) {
                tChunk2.marked = false;
            }
            for (class_2791 chunk : Utils.chunks((boolean)true)) {
                long key = class_1923.method_8331((int)chunk.method_12004().field_9181, (int)chunk.method_12004().field_9180);
                if (this.chunks.containsKey(key)) {
                    ((TChunk)this.chunks.get((long)key)).marked = true;
                    continue;
                }
                if (this.chunkQueue.contains(chunk)) continue;
                this.chunkQueue.add(chunk);
            }
            this.processChunkQueue();
            this.chunks.values().removeIf(tChunk -> !tChunk.marked);
        }
        this.removeBoxesOutsideRenderDistance();
    }

    private void removeBoxesOutsideRenderDistance() {
        HashSet<class_2818> chunkSet = new HashSet<class_2818>();
        for (class_2791 chunk : Utils.chunks((boolean)true)) {
            if (!(chunk instanceof class_2818)) continue;
            chunkSet.add((class_2818)chunk);
        }
        this.removeBoxesOutsideRenderDistance(this.holes, chunkSet);
        this.removeBoxesOutsideRenderDistance(this.tunnels, chunkSet);
        this.removeBoxesOutsideRenderDistance(this.staircases, chunkSet);
    }

    private void removeBoxesOutsideRenderDistance(Set<class_238> boxSet, Set<class_2818> worldChunks) {
        boxSet.removeIf(box -> {
            class_2338 boxPos = new class_2338((int)Math.floor(box.method_1005().method_10216()), (int)Math.floor(box.method_1005().method_10214()), (int)Math.floor(box.method_1005().method_10215()));
            assert (this.mc.field_1687 != null);
            return !worldChunks.contains(this.mc.field_1687.method_22350(boxPos));
        });
    }

    @EventHandler
    private void onRender3D(Render3DEvent event) {
        switch (((DetectionMode)((Object)this.detectionMode.get())).ordinal()) {
            case 0: {
                this.renderHoles(event.renderer);
                this.renderTunnels(event.renderer);
                this.renderStaircases(event.renderer);
                break;
            }
            case 1: {
                this.renderHoles(event.renderer);
                this.renderTunnels(event.renderer);
                break;
            }
            case 2: {
                this.renderHoles(event.renderer);
                this.renderStaircases(event.renderer);
                break;
            }
            case 3: {
                this.renderTunnels(event.renderer);
                this.renderStaircases(event.renderer);
                break;
            }
            case 4: {
                this.renderHoles(event.renderer);
                break;
            }
            case 5: {
                this.renderTunnels(event.renderer);
                break;
            }
            case 6: {
                this.renderStaircases(event.renderer);
            }
        }
    }

    private void renderHoles(Renderer3D renderer) {
        if (this.holes != null) {
            for (class_238 box : this.holes) {
                renderer.box(box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324, (Color)this.holeSideColor.get(), (Color)this.holeLineColor.get(), (ShapeMode)this.shapeMode.get(), 0);
            }
        }
    }

    private void renderTunnels(Renderer3D renderer) {
        if (this.tunnels != null) {
            for (class_238 box : this.tunnels) {
                renderer.box(box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324, (Color)this.tunnelSideColor.get(), (Color)this.tunnelLineColor.get(), (ShapeMode)this.shapeMode.get(), 0);
            }
        }
    }

    private void renderStaircases(Renderer3D renderer) {
        if (this.staircases != null) {
            for (class_238 box : this.staircases) {
                renderer.box(box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324, (Color)this.staircaseSideColor.get(), (Color)this.staircaseLineColor.get(), (ShapeMode)this.shapeMode.get(), 0);
            }
        }
    }

    private void processChunkQueue() {
        int maxChunksPerTick = (Integer)this.maxChunks.get();
        int processed = 0;
        while (!this.chunkQueue.isEmpty() && processed < maxChunksPerTick) {
            class_2791 chunk = this.chunkQueue.poll();
            if (chunk == null) continue;
            TChunk tChunk = new TChunk(this, chunk.method_12004().field_9181, chunk.method_12004().field_9180);
            this.chunks.put(tChunk.getKey(), (Object)tChunk);
            MeteorExecutor.execute(() -> this.searchChunk(chunk, tChunk));
            ++processed;
        }
    }

    private void searchChunk(class_2791 chunk, TChunk tChunk) {
        class_2826[] sections = chunk.method_12006();
        int Ymin = this.mc.field_1687.method_31607() + (Integer)this.minY.get();
        int Ymax = this.mc.field_1687.method_31600() - (Integer)this.maxY.get();
        int Y = this.mc.field_1687.method_31607();
        for (class_2826 section : sections) {
            if (section != null && !section.method_38292()) {
                for (int z = 0; z <= 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        block12: for (int y = 0; y < 16; ++y) {
                            class_2338 pos;
                            int currentY = Y + y;
                            if (currentY <= Ymin || currentY >= Ymax || !this.isPassableBlock(pos = chunk.method_12004().method_35231(x, currentY, z))) continue;
                            switch (((DetectionMode)((Object)this.detectionMode.get())).ordinal()) {
                                case 0: {
                                    this.checkHole(pos, this.holes);
                                    this.checkTunnel(pos);
                                    if (((Boolean)this.diagonals.get()).booleanValue()) {
                                        this.checkDiagonalTunnel(pos);
                                    }
                                    this.checkStaircase(pos);
                                    continue block12;
                                }
                                case 1: {
                                    this.checkHole(pos, this.holes);
                                    this.checkTunnel(pos);
                                    if (!((Boolean)this.diagonals.get()).booleanValue()) continue block12;
                                    this.checkDiagonalTunnel(pos);
                                    continue block12;
                                }
                                case 2: {
                                    this.checkHole(pos, this.holes);
                                    this.checkStaircase(pos);
                                    continue block12;
                                }
                                case 3: {
                                    this.checkTunnel(pos);
                                    if (((Boolean)this.diagonals.get()).booleanValue()) {
                                        this.checkDiagonalTunnel(pos);
                                    }
                                    this.checkStaircase(pos);
                                    continue block12;
                                }
                                case 4: {
                                    this.checkHole(pos, this.holes);
                                    continue block12;
                                }
                                case 5: {
                                    this.checkTunnel(pos);
                                    if (!((Boolean)this.diagonals.get()).booleanValue()) continue block12;
                                    this.checkDiagonalTunnel(pos);
                                    continue block12;
                                }
                                case 6: {
                                    this.checkStaircase(pos);
                                }
                            }
                        }
                    }
                }
            }
            Y += 16;
        }
    }

    private void checkHole(class_2338 pos, Set<class_238> holes) {
        if (this.isValidHoleSection(pos)) {
            class_238 holeBox;
            class_2338.class_2339 currentPos = pos.method_25503();
            while (this.isValidHoleSection((class_2338)currentPos)) {
                currentPos.method_10098(class_2350.field_11036);
            }
            if (currentPos.method_10264() - pos.method_10264() >= (Integer)this.minHoleDepth.get() && !holes.contains(holeBox = new class_238((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (double)(pos.method_10263() + 1), (double)currentPos.method_10264(), (double)(pos.method_10260() + 1))) && holes.stream().noneMatch(existingHole -> existingHole.method_994(holeBox))) {
                holes.add(holeBox);
            }
        }
    }

    private boolean isValidHoleSection(class_2338 pos) {
        return this.isPassableBlock(pos) && !this.isPassableBlock(pos.method_10095()) && !this.isPassableBlock(pos.method_10072()) && !this.isPassableBlock(pos.method_10078()) && !this.isPassableBlock(pos.method_10067());
    }

    private void checkTunnel(class_2338 pos) {
        for (class_2350 dir : DIRECTIONS) {
            class_238 tunnelBox;
            class_2338.class_2339 currentPos = pos.method_25503();
            int stepCount = 0;
            class_2338 startPos = null;
            class_2338 endPos = null;
            int maxHeight = 0;
            if (startPos == null && this.isTunnelSection((class_2338)currentPos, dir)) {
                startPos = currentPos.method_10062();
            }
            while (this.isTunnelSection((class_2338)currentPos, dir)) {
                maxHeight = Math.max(maxHeight, this.getTunnelHeight((class_2338)currentPos));
                endPos = currentPos.method_10062();
                currentPos.method_10098(dir);
                ++stepCount;
            }
            if (stepCount < (Integer)this.minTunnelLength.get() || maxHeight < (Integer)this.minTunnelHeight.get() || maxHeight > (Integer)this.maxTunnelHeight.get() || this.tunnels.contains(tunnelBox = new class_238((double)Math.min(startPos.method_10263(), endPos.method_10263()), (double)startPos.method_10264(), (double)Math.min(startPos.method_10260(), endPos.method_10260()), (double)(Math.max(startPos.method_10263(), endPos.method_10263()) + 1), (double)(startPos.method_10264() + maxHeight), (double)(Math.max(startPos.method_10260(), endPos.method_10260()) + 1))) || !this.tunnels.stream().noneMatch(existingTunnel -> existingTunnel.method_994(tunnelBox))) continue;
            this.tunnels.add(tunnelBox);
        }
    }

    private boolean isTunnelSection(class_2338 pos, class_2350 dir) {
        class_2350[] perpDirs;
        class_2350[] class_2350Array;
        int height = this.getTunnelHeight(pos);
        if (height < (Integer)this.minTunnelHeight.get() || height > (Integer)this.maxTunnelHeight.get()) {
            return false;
        }
        if (this.isPassableBlock(pos.method_10074()) || this.isPassableBlock(pos.method_10086(height))) {
            return false;
        }
        if (dir.method_10166() == class_2350.class_2351.field_11048) {
            class_2350[] class_2350Array2 = new class_2350[2];
            class_2350Array2[0] = class_2350.field_11043;
            class_2350Array = class_2350Array2;
            class_2350Array2[1] = class_2350.field_11035;
        } else {
            class_2350[] class_2350Array3 = new class_2350[2];
            class_2350Array3[0] = class_2350.field_11034;
            class_2350Array = class_2350Array3;
            class_2350Array3[1] = class_2350.field_11039;
        }
        for (class_2350 perpDir : perpDirs = class_2350Array) {
            for (int i = 0; i < height; ++i) {
                if (!this.isPassableBlock(pos.method_10086(i).method_10093(perpDir))) continue;
                return false;
            }
        }
        return true;
    }

    private void checkDiagonalTunnel(class_2338 pos) {
        for (class_2350 dir : DIRECTIONS) {
            for (int i = (Integer)this.minDiagonalWidth.get() - 1; i < (Integer)this.maxDiagonalWidth.get(); ++i) {
                class_2338.class_2339 currentPos = pos.method_25503();
                int stepCount = 0;
                ArrayList<class_238> potentialBoxes = new ArrayList<class_238>();
                class_2350 checkingDir = dir;
                boolean turnRight = true;
                while (this.isDiagonalTunnelSection((class_2338)currentPos, checkingDir)) {
                    int height = this.getTunnelHeight((class_2338)currentPos);
                    class_238 tunnelBox = new class_238((double)currentPos.method_10263(), (double)currentPos.method_10264(), (double)currentPos.method_10260(), (double)(currentPos.method_10263() + 1), (double)(currentPos.method_10264() + height), (double)(currentPos.method_10260() + 1));
                    if (!potentialBoxes.contains(tunnelBox) && !potentialBoxes.stream().anyMatch(existingDiagonal -> existingDiagonal.method_994(tunnelBox))) {
                        potentialBoxes.add(tunnelBox);
                    }
                    if (turnRight) {
                        checkingDir = checkingDir.method_10170();
                        currentPos.method_10104(checkingDir.method_10170(), i);
                        turnRight = false;
                    } else {
                        checkingDir = checkingDir.method_10160();
                        currentPos.method_10104(checkingDir.method_10160(), i);
                        turnRight = true;
                    }
                    ++stepCount;
                }
                if (stepCount / (Integer)this.minDiagonalWidth.get() < (Integer)this.minDiagonalLength.get()) continue;
                potentialBoxes.forEach(potentialBox -> {
                    if (!this.tunnels.contains(potentialBox) && this.tunnels.stream().noneMatch(existingDiagonal -> existingDiagonal.method_994(potentialBox))) {
                        this.tunnels.add((class_238)potentialBox);
                    }
                });
            }
        }
    }

    private boolean isDiagonalTunnelSection(class_2338 pos, class_2350 dir) {
        int height = this.getTunnelHeight(pos);
        if (height < (Integer)this.minTunnelHeight.get() || height > (Integer)this.maxTunnelHeight.get()) {
            return false;
        }
        if (this.isPassableBlock(pos.method_10074()) || this.isPassableBlock(pos.method_10086(height))) {
            return false;
        }
        boolean waspassableblockfound = false;
        for (int i = 0; i < height; ++i) {
            if (!this.isPassableBlock(pos.method_10086(i).method_10093(dir))) continue;
            waspassableblockfound = true;
        }
        return !waspassableblockfound;
    }

    private int getTunnelHeight(class_2338 pos) {
        int height;
        for (height = 0; this.isPassableBlock(pos.method_10086(height)) && height < (Integer)this.maxTunnelHeight.get(); ++height) {
        }
        return height;
    }

    private void checkStaircase(class_2338 pos) {
        for (class_2350 dir : DIRECTIONS) {
            class_2338.class_2339 currentPos = pos.method_25503();
            int stepCount = 0;
            ArrayList<class_238> potentialStaircaseBoxes = new ArrayList<class_238>();
            while (this.isStaircaseSection((class_2338)currentPos, dir)) {
                int height = this.getStaircaseHeight((class_2338)currentPos);
                class_238 stairsBox = new class_238((double)currentPos.method_10263(), (double)currentPos.method_10264(), (double)currentPos.method_10260(), (double)(currentPos.method_10263() + 1), (double)(currentPos.method_10264() + height), (double)(currentPos.method_10260() + 1));
                if (!potentialStaircaseBoxes.contains(stairsBox) && !potentialStaircaseBoxes.stream().anyMatch(existingStaircase -> existingStaircase.method_994(stairsBox))) {
                    potentialStaircaseBoxes.add(stairsBox);
                }
                currentPos.method_10098(dir);
                currentPos.method_10098(class_2350.field_11036);
                ++stepCount;
            }
            for (class_238 stairsBox : potentialStaircaseBoxes) {
                if (stepCount < (Integer)this.minStaircaseLength.get() || this.staircases.contains(stairsBox) || this.staircases.stream().anyMatch(existingStaircase -> existingStaircase.method_994(stairsBox))) continue;
                this.staircases.add(stairsBox);
            }
        }
    }

    private int getStaircaseHeight(class_2338 pos) {
        int height;
        for (height = 0; this.isPassableBlock(pos.method_10086(height)) && height < (Integer)this.maxStaircaseHeight.get(); ++height) {
        }
        return height;
    }

    private boolean isStaircaseSection(class_2338 pos, class_2350 dir) {
        class_2350[] perpDirs;
        class_2350[] class_2350Array;
        int height = this.getStaircaseHeight(pos);
        if (height < (Integer)this.minStaircaseHeight.get() || height > (Integer)this.maxStaircaseHeight.get()) {
            return false;
        }
        if (this.isPassableBlock(pos.method_10074()) || this.isPassableBlock(pos.method_10086(height))) {
            return false;
        }
        if (dir.method_10166() == class_2350.class_2351.field_11048) {
            class_2350[] class_2350Array2 = new class_2350[2];
            class_2350Array2[0] = class_2350.field_11043;
            class_2350Array = class_2350Array2;
            class_2350Array2[1] = class_2350.field_11035;
        } else {
            class_2350[] class_2350Array3 = new class_2350[2];
            class_2350Array3[0] = class_2350.field_11034;
            class_2350Array = class_2350Array3;
            class_2350Array3[1] = class_2350.field_11039;
        }
        for (class_2350 perpDir : perpDirs = class_2350Array) {
            for (int i = 0; i < height; ++i) {
                if (!this.isPassableBlock(pos.method_10086(i).method_10093(perpDir))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isPassableBlock(class_2338 pos) {
        class_2680 state = this.mc.field_1687.method_8320(pos);
        if (((Boolean)this.airBlocks.get()).booleanValue()) {
            return state.method_26215();
        }
        class_265 shape = state.method_26220((class_1922)this.mc.field_1687, pos);
        return shape.method_1110() || !class_259.method_1077().equals((Object)shape);
    }

    public static enum DetectionMode {
        ALL,
        HOLES_AND_TUNNELS,
        HOLES_AND_STAIRCASES,
        TUNNELS_AND_STAIRCASES,
        HOLES,
        TUNNELS,
        STAIRCASES;

    }

    private class TChunk {
        private final int x;
        private final int z;
        public boolean marked;

        public TChunk(HoleTunnelStairs holeTunnelStairs, int x, int z) {
            this.x = x;
            this.z = z;
            this.marked = true;
        }

        public long getKey() {
            return class_1923.method_8331((int)this.x, (int)this.z);
        }
    }
}

